{
 Author:    Craig Ward
 Copyright: none - public domain

 Date:      21/5/96

 Version:   1.0

 Overview:  Audit-Trail component. Logs database actions to text-file, plus,
            shows audit-trail in a TOutline.

 Calling:   Two calls available:
             [1] WriteAction - this writes the info passed to a text file
             [2] Execute - shows dialog

 Fields:    Before using the component, do not forget to set the text-file
            property, plus the user-name property!

*******************************************************************************}
unit Cwaudit;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, DB, DBTables;


type
  TcwAuditTrail = class(TComponent)
  private
    { Private declarations }
    FPrevDate: string;
    FPrevUser: string;
    FTextFile: string;
    FUserName: string;
    procedure SetTextFile(const value: string);
    procedure SetUser(const value: string);
  protected
    { Protected declarations }
  public
    { Public declarations }
    procedure WriteAction(const sTable, sAction: string);
    function Execute: boolean;
    constructor Create(aOwner: TComponent); override;
    destructor Destroy; override;
  published
    { Published declarations }
    property AuditLog: string read FTextFile write SetTextFile;
    property UserName: string read FUserName write SetUser;
  end;

procedure Register;

implementation

uses
 cwaudDlg;

{***VCL Preferences************************************************************}

{register}
procedure Register;
begin
  RegisterComponents('cw_apps', [TcwAuditTrail]);
end;


{create}
constructor TcwAuditTrail.Create(aOwner: TComponent);
begin
 inherited Create(aOwner);
end;

{free}
destructor TcwAuditTrail.Destroy;
begin
 inherited destroy;
end;

{set text file}
procedure TcwAuditTrail.SetTextFile(const value: string);
begin
 if FTextFile <> value then
  FTextFile := value;
end;

{set user}
procedure TcwAuditTrail.SetUser(const value: string);
begin
 if FUserName <> value then
  FUserName := value;
end;

{***I\O************************************************************************}

{write exception message to text file}
procedure TcwAuditTrail.WriteAction(const sTable, sAction: string);
var
 tf: TextFile;
 tc: file of char;
 sLine: ^string;
begin

 {check if file is empty - user could have purged it! -
  in which case, reset the fields that store previous
  values}
 if fileExists(FTextFile) then
  begin
   AssignFile(tc,FTextFile);
   reset(tc);
   if FileSize(tc) = 0 then
    begin
     FPrevDate := '';
     FPrevUser := '';
    end;
   CloseFile(tc);
  end;


 New(sLine);

 {add text to file}
 try

 if FTextFile <> '' then
  begin
   AssignFile(tf,FTextFile);                        {assign field to Text-File}
   if FileExists( FTextFile ) then
    Append(tf)       {prepare to append to file}
   else
    Rewrite(tf);   {create and open}
    {write data to file. Since we will present the data
     in a TListBox, where children can be defined using a tab (#9),
     we check the last log, to see if we should write new information}
   if FPrevDate <> DateToStr(date) then
    WriteLn(tF,DateToStr(date));
   {***}
   if FPrevUser <> FUsername then
    WriteLn(tF,#9+FUserName);
   {***}
   sLine^ := #9+#9+ sAction +' '+ sTable +' at '+ TimeToStr(time);
   WriteLn(tF,sLine^);
   CloseFile(tF); {close file}
   {store information for next log}
   FPrevDate := DateToStr(date);
   FPrevUser := FUsername;
  end;
 finally
  Dispose(sLine);
 end;

end;


{***form***********************************************************************}

{show audit dialog}
function TcwAuditTrail.Execute: boolean;
begin
 result := false;
 screen.cursor := crHourGlass;
 AuditDlg := TAuditDlg.create(application);
 try
  AuditDlg.TextFile := FTextFile;
  AuditDlg.caption := 'Audit Trail';
  {show}
  screen.cursor := crDefault;
  AuditDlg.showModal;
  result := true;
 finally
  AuditDlg.Free;
  screen.cursor := crDefault;
 end;
end;


{}
end.
